Ext.data.JsonP.sol_common_ix_DynAdHocFlowUtils({"tagname":"class","name":"sol.common.ix.DynAdHocFlowUtils","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true,"singleton":true},"files":[{"filename":"lib_sol.common.ix.DynAdHocFlowUtils.js","href":"lib_sol.common.ix.DynAdHocFlowUtils.html#sol-common-ix-DynAdHocFlowUtils"}],"author":[{"tagname":"author","name":"MW, ELO Digital Office GmbH","email":null}],"version":["1.1"],"eloix":true,"requires":["sol.common.MapTable","sol.common.UserUtils","sol.common.WfMap"],"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":[],"uses":[],"members":[{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"logger","tagname":"property","owner":"sol.common.ix.DynAdHocFlowUtils","id":"property-logger","meta":{"private":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"backToPreviousUser","tagname":"method","owner":"sol.common.ix.DynAdHocFlowUtils","id":"method-backToPreviousUser","meta":{}},{"name":"buildConfig","tagname":"method","owner":"sol.common.ix.DynAdHocFlowUtils","id":"method-buildConfig","meta":{"private":true}},{"name":"clearCurrentUser","tagname":"method","owner":"sol.common.ix.DynAdHocFlowUtils","id":"method-clearCurrentUser","meta":{}},{"name":"createDynAdHocFlow","tagname":"method","owner":"sol.common.ix.DynAdHocFlowUtils","id":"method-createDynAdHocFlow","meta":{}},{"name":"hasCurrentUser","tagname":"method","owner":"sol.common.ix.DynAdHocFlowUtils","id":"method-hasCurrentUser","meta":{}},{"name":"hasNextUser","tagname":"method","owner":"sol.common.ix.DynAdHocFlowUtils","id":"method-hasNextUser","meta":{}},{"name":"initialize","tagname":"method","owner":"sol.Base","id":"method-initialize","meta":{"private":true}},{"name":"loadTable","tagname":"method","owner":"sol.common.ix.DynAdHocFlowUtils","id":"method-loadTable","meta":{"private":true}},{"name":"setCurrentUser","tagname":"method","owner":"sol.common.ix.DynAdHocFlowUtils","id":"method-setCurrentUser","meta":{}},{"name":"shiftUser","tagname":"method","owner":"sol.common.ix.DynAdHocFlowUtils","id":"method-shiftUser","meta":{}}],"code_type":"ext_define","singleton":true,"id":"class-sol.common.ix.DynAdHocFlowUtils","classIcon":"icon-singleton","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common.ix.DynAdHocFlowUtils</strong></div></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.common.MapTable' rel='sol.common.MapTable' class='docClass'>sol.common.MapTable</a></div><div class='dependency'><a href='#!/api/sol.common.UserUtils' rel='sol.common.UserUtils' class='docClass'>sol.common.UserUtils</a></div><div class='dependency'><a href='#!/api/sol.common.WfMap' rel='sol.common.WfMap' class='docClass'>sol.common.WfMap</a></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common.ix.DynAdHocFlowUtils.html#sol-common-ix-DynAdHocFlowUtils' target='_blank'>lib_sol.common.ix.DynAdHocFlowUtils.js</a></div></pre><div class='doc-contents'><p>Helper functions for dynamic ad-hoc workflows</p>\n      <p class='version-tag'>Version: <b>1.1</b></p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-requiredConfig' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-logger' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynAdHocFlowUtils'>sol.common.ix.DynAdHocFlowUtils</span><br/><a href='source/lib_sol.common.ix.DynAdHocFlowUtils.html#sol-common-ix-DynAdHocFlowUtils-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynAdHocFlowUtils-property-logger' class='name expandable'>logger</a> : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>\n</div><div class='long'>\n<p>Overrides: <a href=\"#!/api/sol.Base-property-logger\" rel=\"sol.Base-property-logger\" class=\"docClass\">sol.Base.logger</a></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-backToPreviousUser' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynAdHocFlowUtils'>sol.common.ix.DynAdHocFlowUtils</span><br/><a href='source/lib_sol.common.ix.DynAdHocFlowUtils.html#sol-common-ix-DynAdHocFlowUtils-method-backToPreviousUser' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynAdHocFlowUtils-method-backToPreviousUser' class='name expandable'>backToPreviousUser</a>( <span class='pre'>flowId, objId, config</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Back to previous user ...</div><div class='long'><p>Back to previous user</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>flowId</span> : String<div class='sub-desc'><p>Flow ID</p>\n</div></li><li><span class='pre'>objId</span> : String<div class='sub-desc'><p>Object ID</p>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>Configuration</p>\n<ul><li><span class='pre'>userNameKey</span> : String<div class='sub-desc'><p>User name key</p>\n</div></li><li><span class='pre'>currentUserKey</span> : String<div class='sub-desc'><p>Current user key</p>\n</div></li><li><span class='pre'>previousUserKey</span> : String<div class='sub-desc'><p>Previous user key</p>\n</div></li></ul></div></li></ul></div></div></div><div id='method-buildConfig' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynAdHocFlowUtils'>sol.common.ix.DynAdHocFlowUtils</span><br/><a href='source/lib_sol.common.ix.DynAdHocFlowUtils.html#sol-common-ix-DynAdHocFlowUtils-method-buildConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynAdHocFlowUtils-method-buildConfig' class='name expandable'>buildConfig</a>( <span class='pre'>config</span> ) : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Builds the DynAdHocFlow configuration ...</div><div class='long'><p>Builds the DynAdHocFlow configuration</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>Configuration</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>Complete configuration</p>\n</div></li></ul></div></div></div><div id='method-clearCurrentUser' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynAdHocFlowUtils'>sol.common.ix.DynAdHocFlowUtils</span><br/><a href='source/lib_sol.common.ix.DynAdHocFlowUtils.html#sol-common-ix-DynAdHocFlowUtils-method-clearCurrentUser' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynAdHocFlowUtils-method-clearCurrentUser' class='name expandable'>clearCurrentUser</a>( <span class='pre'>flowId, objId, config</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Clears the current user ...</div><div class='long'><p>Clears the current user</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>flowId</span> : String<div class='sub-desc'><p>Flow ID</p>\n</div></li><li><span class='pre'>objId</span> : String<div class='sub-desc'><p>Object ID</p>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>Configuration</p>\n<ul><li><span class='pre'>currentUserKey</span> : String<div class='sub-desc'>\n</div></li></ul></div></li></ul></div></div></div><div id='method-createDynAdHocFlow' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynAdHocFlowUtils'>sol.common.ix.DynAdHocFlowUtils</span><br/><a href='source/lib_sol.common.ix.DynAdHocFlowUtils.html#sol-common-ix-DynAdHocFlowUtils-method-createDynAdHocFlow' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynAdHocFlowUtils-method-createDynAdHocFlow' class='name expandable'>createDynAdHocFlow</a>( <span class='pre'>flowId, objId, userEntries, config</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Creates a new routing ...</div><div class='long'><p>Creates a new routing</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>flowId</span> : String<div class='sub-desc'><p>Flow ID</p>\n</div></li><li><span class='pre'>objId</span> : String<div class='sub-desc'><p>Object ID</p>\n</div></li><li><span class='pre'>userEntries</span> : Array<div class='sub-desc'><p>User entries</p>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>Configuration</p>\n<ul><li><span class='pre'>userNameKey</span> : String<div class='sub-desc'><p>User name key</p>\n</div></li><li><span class='pre'>userIdKey</span> : String<div class='sub-desc'><p>User ID key</p>\n</div></li><li><span class='pre'>append</span> : String<div class='sub-desc'><p>Append users</p>\n</div></li></ul></div></li></ul></div></div></div><div id='method-hasCurrentUser' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynAdHocFlowUtils'>sol.common.ix.DynAdHocFlowUtils</span><br/><a href='source/lib_sol.common.ix.DynAdHocFlowUtils.html#sol-common-ix-DynAdHocFlowUtils-method-hasCurrentUser' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynAdHocFlowUtils-method-hasCurrentUser' class='name expandable'>hasCurrentUser</a>( <span class='pre'>flowId, objId, config</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks whether a current user is set ...</div><div class='long'><p>Checks whether a current user is set</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>flowId</span> : String<div class='sub-desc'><p>Flow ID</p>\n</div></li><li><span class='pre'>objId</span> : String<div class='sub-desc'><p>Object ID</p>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>Configuration</p>\n<ul><li><span class='pre'>currentUserKey</span> : String<div class='sub-desc'>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-hasNextUser' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynAdHocFlowUtils'>sol.common.ix.DynAdHocFlowUtils</span><br/><a href='source/lib_sol.common.ix.DynAdHocFlowUtils.html#sol-common-ix-DynAdHocFlowUtils-method-hasNextUser' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynAdHocFlowUtils-method-hasNextUser' class='name expandable'>hasNextUser</a>( <span class='pre'>flowId, objId, config</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks whether there is a next user in the table ...</div><div class='long'><p>Checks whether there is a next user in the table</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>flowId</span> : String<div class='sub-desc'><p>Flow ID</p>\n</div></li><li><span class='pre'>objId</span> : String<div class='sub-desc'><p>Object ID</p>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>Configuration</p>\n<ul><li><span class='pre'>userNameKey</span> : String<div class='sub-desc'>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n</div></li></ul></div></div></div><div id='method-loadTable' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynAdHocFlowUtils'>sol.common.ix.DynAdHocFlowUtils</span><br/><a href='source/lib_sol.common.ix.DynAdHocFlowUtils.html#sol-common-ix-DynAdHocFlowUtils-method-loadTable' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynAdHocFlowUtils-method-loadTable' class='name expandable'>loadTable</a>( <span class='pre'>flowId, objId, initEmpty, config</span> ) : <a href=\"#!/api/sol.common.MapTable\" rel=\"sol.common.MapTable\" class=\"docClass\">sol.common.MapTable</a><span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Loads the routing table ...</div><div class='long'><p>Loads the routing table</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>flowId</span> : String<div class='sub-desc'><p>Flow ID</p>\n</div></li><li><span class='pre'>objId</span> : String<div class='sub-desc'><p>Object ID</p>\n</div></li><li><span class='pre'>initEmpty</span> : Boolean<div class='sub-desc'>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>Configuration</p>\n<ul><li><span class='pre'>reset</span> : Object<div class='sub-desc'><p>Reset iterator</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/sol.common.MapTable\" rel=\"sol.common.MapTable\" class=\"docClass\">sol.common.MapTable</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-setCurrentUser' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynAdHocFlowUtils'>sol.common.ix.DynAdHocFlowUtils</span><br/><a href='source/lib_sol.common.ix.DynAdHocFlowUtils.html#sol-common-ix-DynAdHocFlowUtils-method-setCurrentUser' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynAdHocFlowUtils-method-setCurrentUser' class='name expandable'>setCurrentUser</a>( <span class='pre'>objId, flowId, userName, config</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Sets the current user ...</div><div class='long'><p>Sets the current user</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'><p>Object ID</p>\n</div></li><li><span class='pre'>flowId</span> : String<div class='sub-desc'><p>Flow ID</p>\n</div></li><li><span class='pre'>userName</span> : String<div class='sub-desc'><p>User name</p>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>Configuration</p>\n<ul><li><span class='pre'>currentUserKey</span> : String<div class='sub-desc'>\n</div></li></ul></div></li></ul></div></div></div><div id='method-shiftUser' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynAdHocFlowUtils'>sol.common.ix.DynAdHocFlowUtils</span><br/><a href='source/lib_sol.common.ix.DynAdHocFlowUtils.html#sol-common-ix-DynAdHocFlowUtils-method-shiftUser' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynAdHocFlowUtils-method-shiftUser' class='name expandable'>shiftUser</a>( <span class='pre'>flowId, objId, config</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the first user and removes the first row of the user table ...</div><div class='long'><p>Returns the first user and removes the first row of the user table</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>flowId</span> : String<div class='sub-desc'><p>Flow ID</p>\n</div></li><li><span class='pre'>objId</span> : String<div class='sub-desc'><p>Object ID</p>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>Configuration</p>\n<ul><li><span class='pre'>currentUserKey</span> : String<div class='sub-desc'>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>userName User name</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloix":true,"singleton":true}});